﻿within ;
package BuildSysPro "EDF's Modelica library for modelling buildings and energy systems"


  annotation (uses(
 Modelica(version="3.2.1")),
  version="2015.12a",
  Documentation(info="<html>
<p>
The <code>BuildSysPro</code> library is a free open-source Modelica library for modeling building and energy systems.
</p>
<p>This library is designed to be used in several contexts including building physics research, global performance evaluation, technology development and impact assessment. It is also a basis for urban and building stock simulation. BuildSysPro is intended for a relatively large audience ranging from R&D scientists to building services engineers.
</p>
<p>
BuildSysPro contains classes to describe the whole building and its energy systems including envelope components, HVAC systems and other energy conversion devices (DHW, thermal and photovoltaic panels…) and boundary conditions models. These classes are compliant with the <code>Thermal.HeatTransfer</code> and <code>Media</code> packages of the Modelica Standard Library to ensure a good level of interoperability with other Modelica libraries. The picture below is an illustration of a building envelope model, and of a whole building+systems model created with <code>BuildSysPro</code>:
</p>
<p align=\"center\">
<img alt=\"image\" src=\"modelica://BuildSysPro/Resources/Images/UsersGuide/BuildSysPro_example.png\" border=\"1\"/>
<img alt=\"image\" src=\"modelica://BuildSysPro/Resources/Images/UsersGuide/BuildSysPro_assembly.png\" border=\"1\"/> <br />
</p>

 <p><b>-----------------------------------------------------------------------<br>
  Licensed by EDF under the Modelica License 2<br>
  Copyright &copy; EDF 2009 - 2016<br>
  This Modelica package is <u>free</u> software and the use is completely at <u>your own risk</u>; it can be redistributed and/or modified under the terms of the Modelica License 2.<br>
  For license conditions (including the disclaimer of warranty) see <a href=\"modelica://BuildSysPro.UsersGuide.ModelicaLicense2\">BuildSysPro.UsersGuide.ModelicaLicense2</a> or visit <a href=\"http://www.modelica.org/licenses/ModelicaLicense2\">http://www.modelica.org/licenses/ModelicaLicense2</a>.<br>
  -----------------------------------------------------------------------</b></p>
</html>",
      revisions="<html>
</html>"));
end BuildSysPro;
